/*
 * Copyright (c) 2019 Amazon.com, Inc. or its affiliates.  All rights
 * reserved.
 *
 * This software is licensed under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation, and
 * may be copied, distributed, and modified under those terms.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
#ifndef INCLUDED_AMAZON_DEBUG_H_
#define INCLUDED_AMAZON_DEBUG_H_

#ifdef ECLIPSE_IDE
#undef __init
#undef __exit
#undef module_param
#undef MODULE_PARM_DESC
#undef module_init(x)
#undef module_exit(x)
#undef MODULE_LICENSE(_license)
#undef MODULE_ALIAS_RTNL_LINK(kind)
#undef MODULE_VERSION(_version)
#undef MODULE_AUTHOR(x)
#undef MODULE_DESCRIPTION(x)

#define __init
#define __exit
#define module_param(name, type, perm)
#define MODULE_PARM_DESC(_parm, desc)
#define module_init(x)
#define module_exit(x)
#define MODULE_LICENSE(_license)
#define MODULE_ALIAS_RTNL_LINK(kind)
#define MODULE_VERSION(_version)
#define MODULE_AUTHOR(x)
#define MODULE_DESCRIPTION(x)

#include <linux/types.h>

#endif


static inline int print_escaped(char* buff, unsigned maxlen, const unsigned char* data, unsigned len)
{
	static char hexvals[] = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f' };
	int i;
	int out_len = 0;
	for (i = 0; (i < len) && (out_len < maxlen); i++)
	{
		unsigned char c = data[i];
		if ((c >= 0x20) && (c <= 0x7E)) {
			if (buff) {
				*(buff++) = c;
			}
			out_len++;
		}
		else
		{
			if (buff) {
				*(buff++) = '\\';
				*(buff++) = 'x';
				*(buff++) = hexvals[c >> 4];
				*(buff++) = hexvals[c & 0xf];
			}
			out_len += 4;
		}
	}
	return out_len;
}


#endif // ifndef INCLUDED_AMAZON_DEBUG_H_
